<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Notification;

use Erlage\Photogram\Data\Dtos\Notification\NotificationLinkedContentDTO;

interface InterfaceNotificationGetter
{
    public function getId(): string;

    public function getToUserId(): string;

    public function getTargetContentId(): string;

    public function getLinkedContent(): NotificationLinkedContentDTO;

    public function getMetaType(): string;

    public function getMetaIsRead(): string;

    public function getMetaIsTransient(): string;

    public function getStampRegistrationDate(): string;

    public function getStampRegistration(): string;

    public function getStampLastUpdate(): string;
}
